let rec max_aux ls n = 
  match ls with
  | [] -> n
  | hd :: tl -> max_aux tl (if hd > n then hd else n)

let max ls = max_aux ls 0

(* Prove the theorem: forall ls: int list. max ls >= 0 *)

(* 
new lemma: forall ls: int list, forall n: int . if n >= 0, max_aux ls n >= 0

base case: ls = []
WTP: if n>= 0, max_aux [] n >= 0

max_aux [] n    (LHS)
= match [] with [] -> n ...  (eval max_aux)
= n             (eval match)
n >= 0          (premise)

inductive case: ls = hd:: tl
IH: forall m: int. if m>=0, max_aux tl m >=0
WTP: if n>= 0, max_aux hd::tl n >= 0
we can use n>=0 as a fact since its in the premise

max_aux hd::tl n      (LHS)
= match hd::tl with ... |hd :: tl -> max_aux tl (if hd > n then hd else n)  (eval max_aux)
= max_aux tl (if hd > n then hd else n)         (eval match)

CASE 1: hd > n

= max_aux tl (hd)     (eval if)
max_aux tl hd >= 0  (since hd > n >= 0 by premise, inductive hypothesis)

CASE 2: hd <= n
= max_aux tl n        (eval if)
max_aux tl n >= 0     (since n>=0 by premise, inductive hypothesis)

QED!

Now, we prove the original theorem: forall ls: int list. max ls >= 0

max ls    (LHS)
= max_aux ls 0    (eval max)
max_aux ls 0 >= 0 (0>=0, lemma)

QED!
*)