
(****************************)
(* Partition Implementation *)
(****************************)

module type PARTITION = sig
  val partition : int -> int list -> int list * int list
end

(* Module for implementing partition function *)
module Partition : PARTITION = struct

(* partition xs around the pivot *)
let partition pivot xs =
  let rec aux smaller greater xs = 
    match xs with
    | [] -> (smaller, greater)
    | x :: xs ->
        if x < pivot then aux (x :: smaller) greater xs
        else aux smaller (x :: greater) xs
  in
  aux [] [] xs

end

(* Quicksort using the partition function *)
let rec quicksort = function
  | [] -> []
  | pivot :: rest ->
      let smaller, greater_or_equal = Partition.partition pivot rest in
      quicksort smaller @ [pivot] @ quicksort greater_or_equal

(***********)
(* TESTING *)
(***********)

module Q = QCheck
module G = QCheck.Gen

type test = QCheck2.Test.t

type 'a arb = 'a Q.arbitrary

module type PTESTS = sig
  val tests : test list
end   

module Test (P:PARTITION) : PTESTS = struct

  exception Unimplemented

  let prop1 = raise Unimplemented (* should have type t -> bool for some t *)
  let arb1 = raise Unimplemented (* should have type t arb from the same t as above *)
  let name1 = "Test partition property 1" (* you can give your property a better name *)

  (* This is one test -- You should make at least 2 tests *)
  let t1 = Q.Test.make ~name:name1 ~count:20 arb1 prop1

  (* Put all tests you make in this list *)
  let tests = [t1]
end