/* *****************************************************************************
 *
 *  Description:  Create a class to model intervals of the real line. Each
 *  interval has a minimum and a maximum, and contains all of the real numbers
 *  between its minimum and its maximum. (This kind of object has applications
 *  in geometry, scheduling, and text editing.) For example, the interval
 *  [3, 6] from 3 to 6 contains 3, π, 5, and 6, but it does not contain 6.21.
 *  (All intervals we deal with will include both endpoints.)
 *
 **************************************************************************** */

public class Interval {
    // instance variables
    private double low; // minimum value in this Interval
    private double high; // maximum value in this Interval

    // constructor
    public Interval(double low, double high) {
        // check for valid arguments
        if (high < low)
          throw ________

        // copy data from constructor arguments to instance vars
        ____;
        ____;
    }

    // text representation
    public String toString() {
        // if you want, use String.format("%.6e", ...);
        return String.format("[%.6e, %.6e]", low, high);
    }

    // other instance methods
    // (e.g. is x in this interval?)
    public boolean contains(double x) {
        return ________;
    }

    // do these intervals intersect?
    public boolean intersects(Interval other) {
        ___________;
    }

    // is this a subset of other interval?
    // (e.g. does the other interval fully contain this one?)
    public boolean subsetOf(Interval other) {
        _________;
    }

    // is this a superset of the other interval?
    // (e.g. does this interval fully contain the other interval?)
    public boolean supersetOf(Interval other) {
        _________;
    }

    // test client
    public static void main(String[] args) {
        // counting years BCE to avoid negative signs
        Interval mesozoic = new Interval(66E6, 252E6);
        Interval jurassic = new Interval(145E6, 201E6);
        StdOut.println("The Mesozoic is " + mesozoic.toString());
        StdOut.println("The Jurassic is " + jurassic); // implicit toString
        StdOut.println(mesozoic.intersects(jurassic)); // true
        StdOut.println(jurassic.subsetOf(mesozoic));   // true
        // add more statements to test instance methods further
    }
}
