// REFERENCE IMPLEMENTATION
// A. Kaplan

public class Translate {
    // function that takes a name of a file containing
    // a condon translation table and returns a symbol
    // table (ST) mapping codons to amino acid letter
    public static ST<String, String> readTable(String filename)  {

        // create the symbol table mapping a 
        // codon to its corresponding amino acid letter
        ST<String, String> table = new ST<String, String>();
    
        // open the file with codon table data
        In codonFile = new In(filename);

        // read the data and store in table
        while (!codonFile.isEmpty()) {
            String codon = codonFile.readString();
            String amino = codonFile.readString();
            table.put(codon, amino);
        }

        // return the table
        return table;
    }

    //  translates a DNA sequence to a protein sequence
    private static void translate(DNA seq, ST<String, String> table)  {

        String dnaSeq = seq.sequence();  // get the DNA sequences
        
        // process each codon - sequences of 3 chars
        for (int i = 0; i < seq.length(); i = i + 3) {
            String codon = dnaSeq.substring(i, i + 3); // get a codon
            // if a start codon is GTG (i.e. appears at the beginning of the gene),
            // translate it to "Met"
            if ((i == 0) && (codon.equals("GTG")))
                StdOut.println("Met");
            // translate the codon, only if not mapped to a "*"
            else {
                String code = table.get(codon);
                if (!code.equals("*"))
                    StdOut.println(code);
            }
        }

    }
    
    public static void main(String[] args) {
        // create the table
        ST<String, String> codonTable = readTable(args[0]);

        // read sequencing data
        // create the DNA object
        String name = StdIn.readString();
        String seq = StdIn.readString();
        DNA dna = new DNA(name, seq);
        
        // if it's not a gene, print error
        if (!dna.isGene()) {
            StdOut.println(name);
            StdOut.println("Error");
        }
        // otherwise print the protein sequence
        else {
            StdOut.println(name);
            translate(dna, codonTable);
        }
    }
}
