(* Consider the function gen1 below. *)

let gen1 (l:int list) : int -> int =
  fun (x:int) -> List.fold_left (fun acc next -> (next * x) + acc) 0 l

(* Now consider the following client code that uses the function gen1: *)

let data =
  [
    [1;2;3;4;5;6;7;8;9;0;1;2;3;4;5;6;7;8;9;0];
    [0;9;8;7;6;5;4;3;2;1];
    [];
    [1;3;2;4;6;7];
    [1;2;3;4;5;6;7;8;9;0]
  ]

let output = List.map gen1 data

(*
Write a new function gen2 that when used by the client code in place
of gen1 results in a substantially smaller (in terms of space) value
output.  Your new function gen2 must have the same type as gen1 and
must be functionally equivalent to gen1 (but you don't have to prove
that).

First, in a sentence or two, explain your main idea for reducing the
size of output - even if you can't quite figure out how to rewrite the
code correctly, you can explain a good way one might try to save
space.  Also, if you need to make any assumptions about your solution
state them here clearly.

Explanation:


Write a test to check that the output of gen2 matches the output of gen1.
*)

let gen2 (l:int list) : int -> int = failwith "unimplemented"
