type var = string
type form =
    Var of var
  | And of form * form
  | Or of form * form
type assignment = (var * bool) list


exception NotAssigned of var

let rec lookup (x:var) (a:assignment): bool =
  match a with
  | [] -> raise (NotAssigned x)
  | (hdv,hdb)::tl ->
      if hdv = x then hdb
      else lookup x tl

let rec sats (f:form) (a:assignment) : bool =
  match f with
  | And (l,r) -> (sats l a) && (sats r a)
  | Or (l,r) -> (sats l a) || (sats r a)
  | Var x -> lookup x a

(* x && (y || z) *)
let frm:form = And (Var "x", Or(Var "y", Var "z"))
let t:assignment = [ ("z", true) ; ("x", true) ; ("y", false) ]
let f1:assignment = [ ("z", false) ; ("x", true) ; ("y", false) ]
let f2:assignment = [ ("z", true) ; ("x", false) ; ("y", true) ]

let at = sats frm t
let af1 = sats frm f1
let af2 = sats frm f2
