let delay () = Thread.delay (Random.float 1.);; 

(* get and set references with some random delay to increase non-determinism *)
let get r = delay (); !r ;;

let set r v = delay (); r := v ;;

let f r = 
  let t1 = get r in     (* 1 *)
  let t2 = get r in     (* 2 *)
  set r (t1 + t2 + 1)   (* 3 *)
;;

let g r = 
  let t = get r * 5 in  (* 4 *)
  set r t               (* 5 *)
;;

let run i random_seed =
  Random.init random_seed;
  let r = ref 1 in
  let t = Thread.create f r in
  g r;
  Thread.join t;
  Printf.printf "Result for run %d is %d\n" i !r; 
  flush stdout
;;

let main () =
  (* run 3 times, varying the random delay and see different results *)
  run 1 17;
  run 2 9;
  run 3 19
;;

main ();;
