type 'a future = {tid : Thread.t; value : 'a option ref};;

let future f x = 
  let r = ref None in     
  let t = Thread.create (fun () -> r := Some(f x)) () in    
  {tid=t ; value=r}
;;

let force (f:'a future) : 'a = 
  Thread.join f.tid;
  match !(f.value) with
    | Some v -> v    
    | None -> failwith "impossible!"
;;
