(* Implements a wobbly counter *)
(* Illustrates the non-atomicity of operations in threads *)

(* the function f below loops from 1 to 10, adding 1 to result each
 * time around the loop.  You might expect that since we execute 2 such
 * functions in separate threads, the final value in result will wind up
 * being 20.  However, you will probably see the final value winding up
 * less than that (it turns out to be 15 when I run it).  If you change
 * the value of the initial seed from 17 to something else, you will 
 * likely see some different result.
 *
 * Note that we placed some random delays in between each operation in
 * the loop so that one thread may yield execution to the other for
 * some random amount of time.
*)

let random_seed = 17

let main () =
  let result = ref 0 in
  let print_result i r =
    if i = 1 then
      Printf.printf "    %d\n" r
    else
      Printf.printf "                          %d\n" r;
    flush stdout
  in
  let delay() = Thread.delay (Random.float 0.2) in
  let f i =
    for j = 1 to 10 do
      let v = !result in          delay();
      result := v + 1;            delay();
      print_result i (!result);   delay()
    done in
  Random.init random_seed;  
  Printf.printf "Thread 1 Action    Thread 2 Action\n";
  let t1 = Thread.create f 1 in
  f 2;
  Thread.join t1;
;;

main ();;
