open Format
open InfoSyntax
open EvalSubst

(* Uses pretty printing to print out the 
original expression and its evaluation. *)
let print_evaluation (e: Syntax.exp) = 
  let eval =
      try Printing.string_of_exp (EvalEnv.eval e)
      with | _ -> "Evaluation Error"
      in
  let eval2 = EvalSubst.eval e in
  print_string "EvalEnv Evaluated expression:\n   "; 
  print_string (Printing.string_of_exp e);
  print_string "\nto:\n  ";
  print_string (eval);
  print_string "\nEvalSubst Evaluated expression:\n   "; 
  print_string (Printing.string_of_exp e);
  print_string "\nto:\n  ";
  print_string (Printing.string_of_exp eval2);
  print_string "\n\n"

(* If possible, evaluates the expression in file fname and prints out 
the result. Otherwise, prints out an error message. *)
let eval_from_file fname =
    try 
        (let e = Input.read_from_file fname in
         let _ = Typing.typecheck_exp e in
         let convert = InfoSyntax.to_exp e in
         print_evaluation convert)
    with
    | Error.DescriptiveError msg -> print_string (msg^"\n")
    | _ -> 
       print_string "Error parsing and evaluating ";
       print_string fname;
       print_string "\n"

(* If possible, reads, parses, and evaluates the file specified by the first 
command-line argument. Otherwise, prints out an error message. *)
let rec run_tests (tests: string list) =
  match tests with
  | a::b ->
    let _ = 
    try 
      eval_from_file a
    with
    | _ -> 
      Error.print_error_msg "Error reading and parsing file from command-line..." in
    run_tests b
  | [] -> ()
