type t = {fname: string; start_line: int; end_line: int; start_char: int; end_char: int} [@@deriving show, ord]

(* Returns a new span that extends from x to y. *)
let extend (x: t) (y: t) : t =
  	assert (x.fname = y.fname);
  	let sc = 
  		if x.start_line = y.start_line then min x.start_char y.start_char
  		else if x.start_line < y.start_line then x.start_char
  		else y.start_char
  	in
  	let ec =
  		if x.end_line = y.end_line then max x.end_char y.end_char
  		else if x.end_line > y.end_line then x.end_char
  		else y.end_char
  	in	 
  	let sl = min x.start_line y.start_line in
  	let el = max x.end_line y.end_line in
	{x with start_line = sl; end_line = el; start_char = sc; end_char=ec}

let default = {fname = ""; start_line = -1; end_line = -1; start_char = -1; end_char = -1}

(* Returns the string representation of a span *)
let string_of_span (span: t) =
	let f = span.fname in
  let sc = span.start_char in 
  let ec = span.end_char in
  let sl = span.start_line in
  let el = span.end_line in
  let header = (if f = "" then "" else Printf.sprintf "%s: " f) in
	if sl = el then 
  		if sc = ec then Printf.sprintf "%sline %d, char %d" header sl sc
      else Printf.sprintf "%sline %d, chars %d-%d" header sl sc ec
  else 
  		Printf.sprintf "%sline %d, char %d - line %d, char %d" header sl sc el ec