open Format
open InfoSyntax

(* Uses pretty printing to print out the 
original expression and its evaluation. *)
let print_evaluation (e: Syntax.exp) = 
    let eval = EvalEnv.eval e in
    open_vbox 0;
        open_hbox (); 
            print_string "Evaluated"; 
            print_space (); 
            print_string "expression:"; 
        close_box ();
        print_break 1 2;
        print_string (Printing.string_of_exp e);
        print_break 1 0;
        print_string "to:";
        print_break 1 2;
        print_string (Printing.string_of_exp eval);
        print_break 1 0;
    close_box ()



(* If possible, evaluates the expression in file fname and prints out 
the result. Otherwise, prints out an error message. *)
let eval_from_file fname =
    try 
        (let e = Input.read_from_file fname in
         let _ = Typing.typecheck_exp e in
         let convert = InfoSyntax.to_exp e in
         print_evaluation convert)
    with
    | Error.DescriptiveError msg -> print_string (msg^"\n")
    | _ -> 
        open_hbox (); 
            print_string "Error"; print_space(); print_string "parsing"; 
            print_space(); print_string "and"; print_space(); print_string "evaluating";
            print_space(); print_string fname;
        close_box ()

(* If possible, reads, parses, and evaluates the file specified by the first 
command-line argument. Otherwise, prints out an error message. *)
let () =
    try 
        (let filename = Sys.argv.(1) in
        eval_from_file filename) 
    with
    | _ -> 
        Error.print_error_msg "Error reading and parsing file from command-line..."
