(*************************************************)
(* An environment-based evaluator for Dynamic ML *)
(*************************************************)


(* evaluate input to a value *)
val eval : Syntax.exp -> Syntax.exp

(* evaluate input to a value while printing intermediate results *)
val debug_eval : Syntax.exp -> Syntax.exp


(* create a list of free variables in an expression 
val fv : Syntax.exp -> Syntax.variable list

(* print variables in a variable list *)
val print_vars : Syntax.variable list -> unit
*)
val eval_body : Syntax.env -> (Syntax.env -> Syntax.exp -> Syntax.exp) -> Syntax.exp -> Syntax.exp 
