exception Error
exception EOF of string
exception DescriptiveError of string

(* Raises a general error. *)
val error : unit -> 'a

(*Raises a descriptive error based on the given string. *)
val error_msg : string -> 'a

(* Raises an end-of-file error. *)
val eof_error : int * int -> 'a

(*Raises a descriptive error based on the given strings and span. *)
val type_error : string -> string -> string -> Span.t -> 'a

(*Raises a descriptive error where the string is the unbound variable 
and the Span.t is the original location of the unbound variable. *)
val unbound_error : string -> Span.t -> 'a

(*Raises a descriptive error where the Span.t is the original 
location of the bad operator. *)
val op_error : Span.t -> 'a

(* Uses the pretty-printing module to properly print out the given string. *)
val print_error_msg : string -> unit
