package edu.princeton.cs.lift.checkstyle;

/**
 * Representation of a TOY line of code.
 *
 */
public class ToyLine {
    /** Text of the TOY line of code. */
    private final String text;

    /** Line number. */
    private final int lineNo;

    /** Column number. */
    private final int columnNo;

    /**
     * Creates new instance.
     * @param text the text that make up the TOY line of code.
     * @param lineNo line number.
     * @param columnNo column number
     */
    public ToyLine(String text, int lineNo, int columnNo) {
        this.text = text;
        this.lineNo = lineNo;
        this.columnNo = columnNo;
    }

    public String getText() {
        return text;
    }

    public int getLineNo() {
        return lineNo;
    }

    public final int getColumnNo() {
        return columnNo;
    }

    public String toString() {
        final String separator = ":";
        return "ToyStatement[" + lineNo + separator + columnNo + "]";
    }
}
