/**
 * This is the interface for an object that generates a sequence of
 * states as an MDP is simulated.  The interface specifies the
 * existance of the <tt>nextState</tt> method which returns one more
 * state in the sequence each time it is called.
 */
public interface MdpSimulator {

    /**
     * Returns the next state in the sequence of states being
     * generated by this simulator.
     */
    public int nextState();
}
