/** This is a template of the <tt>MyGenerator</tt> class that must be
 * turned in.  See <tt>RandomCnfGenerator</tt> or
 * <tt>RandomSatisfiedCnfGenerator</tt> for sample code, and see
 * <tt>Generator</tt> for further explanation.
 */
public class MyGenerator implements Generator {

    /** A constructor for this class.  You must have a constructor
     * taking no arguments.  (You may have other constructors that you
     * use for your experiments, but this is the constructor that will
     * be used as part of the class implementation challenge.)
     */
    public MyGenerator() {
	// fill in initialization code here
    }

    /** This is the method that generates CNF formulas, represented by
     * <tt>Cnf</tt> objects, each time it is called.
     */
    public Cnf getNext() {
	// fill in generation code here
    }

    /** This method should simply return the "author" of this program
     * as you would like it to appear on a class website.  You can use
     * your real name or a pseudonym of your choice.
     */
    public String author() {
	// fill in author code here
    }

    /** This method should return a very brief (1-3 sentence)
     * description (appropriate for posting on the class website) of
     * how the CNF formulas are generated by this generator.
     */
    public String description() {
	// fill in description code here
    }


    /** This is a simple <tt>main</tt>.  It generates a CNF using
     * <tt>MyGenerator</tt>.  Once generated, <tt>MySatSolver</tt> is
     * called to try to solve the CNF within the time limit specified
     * by the first argument.  This process is repeated the number of
     * times specified by the second argument.
     */
    public static void main(String[] argv) {
	int time_limit = 0;
	int num_reps = 0;
	try {
	    time_limit = Integer.parseInt(argv[0]);
	    num_reps = Integer.parseInt(argv[1]);
	}
	catch (Exception e) {
	    System.err.println("Arguments: <time_limit> <num_reps>");
	    return;
	}

	Generator gen = new MyGenerator();
	SatSolver sat = new MySatSolver();

	Cnf.runSat(gen, sat, num_reps, time_limit);
    }

}
