/** The interface for a CNF <tt>Generator</tt>.  Each time the
 * <tt>getNext</tt> method is called, a new CNF, represented as a
 * <tt>Cnf</tt> object, is generated and returned.  In addition,
 * classes that implement this interface must include a method
 * returning the "author" of the program, and also a method returning
 * a brief description of how the CNF formulas are generated.
 */
public interface Generator {

    /** This method returns a new CNF formula each time it is called. */
    public Cnf getNext();

    /** This method should simply return the "author" of this program
     * as you would like it to appear on a class website.  You can use
     * your real name or a pseudonym of your choice.
     */
    public String author();

    /** This method should return a very brief (1-3 sentence)
     * description (appropriate for posting on the class website) of
     * how the CNF formulas are generated by this generator.
     */
    public String description();

}
