// Source file for the grid conversion to ascii text



// Include files 

#include "R3Shapes/R3Shapes.h"



int 
main(int argc, char **argv)
{
  // Check number of arguments
  if (argc != 2) {
    printf("Usage: grdinfo gridfile\n");
    exit(0);
  }

  // Parse program arguments
  char *grid_name = argv[1];

  // Allocate a grid
  R3Grid *grid = new R3Grid();
  if (!grid) {
    RNFail("Unable to allocate grid");
    exit(-1);;
  }

  // Read grid
  int status = grid->ReadFile(grid_name);
  if (!status) {
    RNFail("Unable to read grid file %s", grid_name);
    exit(-1);
  }

  // Print info
  const R3Box bbox = grid->WorldBox();
  RNInterval grid_range = grid->Range();
  printf("  Resolution = %d %d %d\n", grid->XResolution(), grid->YResolution(), grid->ZResolution());
  printf("  World Box = ( %g %g %g ) ( %g %g %g )\n", bbox[0][0], bbox[0][1], bbox[0][2], bbox[1][0], bbox[1][1], bbox[1][2]);
  printf("  Spacing = %g\n", grid->GridToWorldScaleFactor());
  printf("  Cardinality = %d\n", grid->Cardinality());
  printf("  Volume = %g\n", grid->Volume());
  printf("  Minimum = %g\n", grid_range.Min());
  printf("  Maximum = %g\n", grid_range.Max());
  printf("  L1Norm = %g\n", grid->L1Norm());
  printf("  L2Norm = %g\n", grid->L2Norm());

  // Return success
  return 0;
}
