import java.awt.Color; //open imported library
import java.awt.Image;
//image manipulation
import java.awt.image.BufferedImage;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
//import java.awt.MediaTracker;
//import javax.swing.ImageIcon;
//import java.net.URL;

public class TransformationCentral {
    
    public static void transform(String filename, double desiredwidth, int rows, int cols) {
        
        //Database.load();
        Picture img = new Picture(filename);
        
        // these two statements alters desired width so
        // it is a nice multiple of the tile width
        int tilewidth = (int)(desiredwidth / cols);
        int imgwidth = tilewidth*cols; // desiredwidth is updated
        
        double ratio = desiredwidth / img.width();
        
        int imgheight = (int)(ratio*img.height());
        int tileheight = (int)(imgheight / rows);
        imgheight = tileheight*rows; // desiredheight is updated
        
        img.resize(imgwidth, imgheight);
        /*
        StdDraw.setCanvasSize(imgwidth, imgheight);
        StdDraw.setXscale(0, imgwidth);
        StdDraw.setYscale(0, imgheight);
        StdDraw.picture(imgwidth/2, imgheight/2, img.getFilename(), imgwidth, imgheight);
        */
        // this disects main photos into tiles
        // row and col are the coords of the top left corner of each tile
        for (int row = 0; row < imgheight; row += tileheight) {
            for (int col = 0; col < imgwidth; col += tilewidth) {
                
                Picture tile = new Picture(tilewidth, tileheight);
                
                for (int x = 0; x < tilewidth; x++) {
                    for (int y = 0; y < tileheight; y++) {
                        
                        Color pixel = img.get(col + x, row + y);
                        tile.set(x, tileheight - 1 - y, pixel);
                        
                    }
                }
                
                Picture bestmatch = Comparer.getBestMatches(tile, 15.0);
                
                //StdDraw.picture(col + (tilewidth/2), imgheight - tileheight - row + (tileheight/2), bestmatch.getFilename(), tilewidth, tileheight);
                
            }
        }
        
    }
    
    public static BufferedImage resize(BufferedImage img, int width, int height) {
        
        // Create new (blank) image of required (scaled) size
        
        BufferedImage scaledImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        
        // Paint scaled version of image to new image
        
        Graphics2D graphics2D = scaledImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION,
                                    RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(img, 0, 0, width, height, null);
        
        // clean up
        
        graphics2D.dispose();
        
        return scaledImage;
        
    }
    
    public static void main(String[] args) {
        
        String filename = args[0];
        double desiredwidth = Double.parseDouble(args[1]);
        int rowdivisions = Integer.parseInt(args[2]);
        int coldivisions = Integer.parseInt(args[3]);
        
        TransformationCentral.transform(filename, desiredwidth, rowdivisions, coldivisions);
        
    }
    
}