//creates database using folder of photos

import java.awt.Color;
import java.io.*;
import javax.swing.filechooser.FileFilter;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.util.ArrayList;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;

public class Storer {
    
    public static void saveVals(Picture img) {
        
        /*
        StdOut.print(img.getFilename());
        StdOut.print(",");
        
        double[] avgvals = InfoFinder.findAverages(img);
        StdOut.print(avgvals[0]);
        StdOut.print(",");
        StdOut.print(avgvals[1]);
        StdOut.print(",");
        StdOut.print(avgvals[2]);
        StdOut.println();
        */
        
    }
    
    
    public static ArrayList<String> saveFolder(String directory, String dbname){
        
        try{
            File folder = new File(directory);
            String[] filenames = folder.list();
            ArrayList<String> valid = new ArrayList<String>();
            ArrayList<String> invalid = new ArrayList<String>();
            
            String regex_ext = "[Pp][Nn][Gg]|[Jj][Pp][Ee]*[Gg]|[Gg][Ii][Ff]|[Tt][Ii][Ff][Ff]*";
            Pattern pattern = Pattern.compile(regex_ext);
            
            // finds any invalid files and sends them back, stores the rest
            for (int i = 0; i < filenames.length; i++) {
                if (filenames[i].substring(0, 1).equals(".")) {continue;} // on macs, hidden files start with period
                String suffix = filenames[i].substring(filenames[i].lastIndexOf('.') + 1);
                Matcher matcher = pattern.matcher(suffix);
                if (matcher.find()) // sees that it is a picture
                    valid.add(filenames[i]);
                else
                    invalid.add(filenames[i]);
            }
            
            if (!valid.isEmpty()) {
                // Create file 
                FileWriter fstream = new FileWriter(dbname);
                BufferedWriter out = new BufferedWriter(fstream);
                
                out.write("" + valid.size());
                for (int i = 0; i < valid.size(); i++) {
                    
                    out.newLine();
                    out.write("" + i);          // index number
                    out.write(","); 
                    out.write(directory + File.separator + valid.get(i));   // filename
                    out.write(",");
                    
                    BufferedImage pic = ImageIO.read(new File(directory + File.separator + valid.get(i)));
                    
                    double[] avgvals = InfoFinder.findAverages(pic);
                    out.write("" + avgvals[0]); // cannot write out doubles
                    out.write(",");
                    out.write("" + avgvals[1]);
                    out.write(",");
                    out.write("" + avgvals[2]);
                    
                }
                //Close the output stream
                out.close();
                
                return invalid;
                
            }
            else return null;
        } catch (Exception e){//Catch exception if any
            System.err.println("Error: " + e.getMessage());
        }
        
        return null;
        
    }
    
    public static void main(String args[]) {
        /*
        StdOut.println(args.length); //stores number of items in database
        
        for (int i = 0; i < args.length; i++) {
            
            StdOut.print(i); //index for each photo
            StdOut.print(",");
            
            Picture img = new Picture(args[i]);
            
            Storer.saveVals(img);
        }
        */
        
    }
    
}