import java.awt.Container;
import javax.swing.JWindow;
import java.awt.image.BufferedImage;
import java.awt.Graphics;
import javax.swing.JPanel;
import java.io.File;
import javax.imageio.ImageIO;
import java.io.IOException;

public class Preview extends JWindow {
    
    private int MIN_WIDTH;
    private int MAX_WIDTH;
    Tile tile;
    
    //Create a frame with a button.
    public Preview(int min, int max) {
        
        MIN_WIDTH = min;
        MAX_WIDTH = max;
        tile = new Tile();
        this.add(tile);
        
    }
    
    public void loadImg(String dir) {
     
        BufferedImage img = makeImage(dir);
        resizeBoth(img);
        tile.loadImage(img);
        
    }
    
    // resizes preview window according to image dimensions
    public void resizeBoth(BufferedImage img) {
        
        int width, height;
        if (img.getWidth() >= MAX_WIDTH)  {
            
            double ratio = (double)MAX_WIDTH / (double)img.getWidth();
            width = MAX_WIDTH;
            height = (int)(ratio*img.getHeight());
            
        }
        else {
            
            if (img.getWidth() < MIN_WIDTH) {
                
                double ratio = (double)MIN_WIDTH / (double)img.getWidth();
                width = MIN_WIDTH;
                height = (int)(ratio*img.getHeight());
            }
            else {
                
                width = img.getWidth();
                height = img.getHeight();
                
            }
            
        }
        
        this.setSize(width, height);
        tile.setSize(width, height);
        
    }
    
    private BufferedImage makeImage(String dir) {
        
        File file = new File(dir);
        
        try {
            if (file.isFile())
                return ImageIO.read(file);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open file: " + dir);
        }
        
        return null;
        
    }
    
    // Tile Class ==============================================================
    
    // jpanel containing image of the tile
    class Tile extends JPanel {
        
        private BufferedImage tileimg;
        
        // empty constructor
        public Tile() {
            
        }
        
        public void loadImage(BufferedImage img) {
            
            tileimg = img;
            repaint();
            
        }
       
        
        @Override public void paintComponent(Graphics g) {
            
            if (tileimg != null) {
                
                super.paintComponent(g);
                g.drawImage(tileimg, 0, 0, this.getWidth(), this.getHeight(), this);
                
            }
            
        }
        
    }
    
}