// adapted from http://www.compuphase.com/cmetric.htm

import java.awt.Color; //open imported library
import java.awt.image.BufferedImage;

// calculates certain values
public class InfoFinder{
    
    public static double colorDistance (Color c1, Color c2) {
        
        double rmean = ( (double)c1.getRed() + (double)c2.getRed() ) / 2; 
        double r = (double)c1.getRed() - (double)c2.getRed(); 
        double g = (double)c1.getGreen() - (double)c2.getGreen(); 
        double b = (double)c1.getBlue() - (double)c2.getBlue(); 
        return Math.sqrt((2.0 + r/256)*r*r + 4.0*g*g + (2.0 + (225.0-r)/256)*b*b); 
        
    }
    
    public static double[] findAverages(Picture img) {
        
        double width = img.width();
        double height = img.height();
        double pixelcount = width*height;
        
        double r = 0, g = 0, b =0;
        
        for (int row = 0; row < height; row++) {
            for (int col = 0; col < width; col++) {
                
                Color color = img.get(col, row);
                r += color.getRed();
                g += color.getGreen();
                b += color.getBlue();
                
            }
        }
        
        double[] avgvals = new double[3];
        avgvals[0] = r / pixelcount;
        avgvals[1] = g / pixelcount;
        avgvals[2] = b / pixelcount;
        
        return avgvals;
        
    }
    
    public static double[] findAverages(BufferedImage img) {
        
        double width = img.getWidth();
        double height = img.getHeight();
        double pixelcount = width*height;
        
        double r = 0, g = 0, b =0;
        
        for (int row = 0; row < height; row++) {
            for (int col = 0; col < width; col++) {
                
                Color color = new Color(img.getRGB(col, row));
                r += color.getRed();
                g += color.getGreen();
                b += color.getBlue();
                
            }
        }
        
        double[] avgvals = new double[3];
        avgvals[0] = r / pixelcount;
        avgvals[1] = g / pixelcount;
        avgvals[2] = b / pixelcount;
        
        return avgvals;
        
    }
    
    /**
     * Validates if input String is a number
     */
    public static boolean checkIfDouble(String in) {
        
        try {

            Double.parseDouble(in);
        
        } catch (NumberFormatException ex) {
            return false;
        }
        
        return true;
    }
    
    public static boolean checkIfInt(String in) {
        
        try {

            Integer.parseInt(in);
        
        } catch (NumberFormatException ex) {
            return false;
        }
        
        return true;
    }
    
}