import java.awt.Color; //open imported library
import java.util.ArrayList;
import java.awt.image.BufferedImage;

public class Comparer {
    
    public static Picture getBestMatch(Picture img, double TOLERANCE) {
        
        double[] imgvals = InfoFinder.findAverages(img);
        Color imgcolor = new Color((int)imgvals[0], (int)imgvals[1], (int)imgvals[2]);
        double mindist = Double.POSITIVE_INFINITY;
        String directory = ""; // directory of the best matching image
        
        for (int i = 0; i < DatabaseNew.db.length; i++) {
            
            int dbr = (int)Double.parseDouble(DatabaseNew.db[i][2]);
            int dbg = (int)Double.parseDouble(DatabaseNew.db[i][3]);
            int dbb = (int)Double.parseDouble(DatabaseNew.db[i][4]);
            
            Color dbimgcolor = new Color(dbr, dbg, dbb);
            double cdist = InfoFinder.colorDistance(imgcolor, dbimgcolor);
            //System.out.println("\"" + dbimginfo[1] + "\" is a color distance of " + cdist + " away from source image.");
            if (cdist < mindist) { // if min distance, keep dbimg
                directory = DatabaseNew.db[i][1];
                mindist = cdist;
            }
            
        }
        
        return new Picture(directory);
        
    } 
    
    
    public static Picture getBestMatches(Picture img, double TOLERANCE) {
        
        double[] imgvals = InfoFinder.findAverages(img);
        Color imgcolor = new Color((int)imgvals[0], (int)imgvals[1], (int)imgvals[2]);
        ArrayList<String>directories = new ArrayList<String>();   // directory of the best matching image
        double mindist = Double.POSITIVE_INFINITY;
        String directory = ""; // best directory
        String closest = ""; // if no photos are found within tolerance, pick closest photo
        
        
        for (int i = 0; i < DatabaseNew.db.length; i++) {
            
            int dbr = (int)Double.parseDouble(DatabaseNew.db[i][2]);
            int dbg = (int)Double.parseDouble(DatabaseNew.db[i][3]);
            int dbb = (int)Double.parseDouble(DatabaseNew.db[i][4]);
            
            Color dbimgcolor = new Color(dbr, dbg, dbb);
            double cdist = InfoFinder.colorDistance(imgcolor, dbimgcolor);
            
            if (cdist <= TOLERANCE) {
                directories.add(DatabaseNew.db[i][1]);
            }
            if (cdist < mindist) { // if min distance, keep dbimg
                directory = DatabaseNew.db[i][1];
                mindist = cdist;
                closest = DatabaseNew.db[i][1];
            }
            
        }
        
        if (directories.size() > 0)// select a random photo from the list of best directories
            directory = directories.get((int)(Math.random()*directories.size()));
        else
            directory = closest;
        
        return new Picture(directory);
        
    } 
    
    public static Picture getBestMatches(BufferedImage img, double TOLERANCE) {
        
        double[] imgvals = InfoFinder.findAverages(img);
        Color imgcolor = new Color((int)imgvals[0], (int)imgvals[1], (int)imgvals[2]);
        ArrayList<String>directories = new ArrayList<String>();   // directory of the best matching image
        double mindist = Double.POSITIVE_INFINITY;
        String directory = ""; // best directory
        String closest = ""; // if no photos are found within tolerance, pick closest photo
        
        for (int i = 0; i < DatabaseNew.db.length; i++) {
            
            int dbr = (int)Double.parseDouble(DatabaseNew.db[i][2]);
            int dbg = (int)Double.parseDouble(DatabaseNew.db[i][3]);
            int dbb = (int)Double.parseDouble(DatabaseNew.db[i][4]);
            
            Color dbimgcolor = new Color(dbr, dbg, dbb);
            double cdist = InfoFinder.colorDistance(imgcolor, dbimgcolor);
            
            if (cdist <= TOLERANCE) {
                directories.add(DatabaseNew.db[i][1]);
            }
            if (cdist < mindist) { // if min distance, keep dbimg
                directory = DatabaseNew.db[i][1];
                mindist = cdist;
                closest = DatabaseNew.db[i][1];
            }
            
        }
        
        if (directories.size() > 0)// select a random photo from the list of best directories
            directory = directories.get((int)(Math.random()*directories.size()));
        else
            directory = closest;
        
        return new Picture(directory);
        
    } 
    
    public static void main(String[] args) {
        
        Picture img = new Picture(args[0]);
        
        //Database.load();
        Picture bestmatch = Comparer.getBestMatch(img, 15.0);
        
        //StdDraw.setXscale(0, bestmatch.width());
        //StdDraw.setYscale(0, bestmatch.height());
        //StdDraw.picture(bestmatch.width()/2, bestmatch.width()/2, bestmatch.getFilename());
        
    }
    
}